#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmProcessShipmentIn;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_BloodUnitMedia : BaseTest 
	{
		
		private BOL.BloodUnitMedia _tstBUM;
		private DataTable _dtBloodUnitMedia;
		private Guid _unitGuid;
		private Guid _bpGuid;		//Active codabar RBC blood product guid
		private int _componentClassId;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE DirectedPatientGuid IS NOT NULL AND UnitExpirationDate > GETUTCDATE() AND DivisionCode = '" + this.TestDivisionCode + "'", false);
				if (dtTemp.Rows.Count == 0)
				{
					Guid patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");
					Guid bpGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.ConversionClass).BloodProductGuid;
					DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), patientGuid, bpGuid, true);
					dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE DirectedPatientGuid IS NOT NULL AND UnitExpirationDate > GETUTCDATE() AND DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				this._unitGuid = (Guid)dtTemp.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid];
				this._componentClassId = (int)dtTemp.Rows[0][TABLES.ComponentClass.ComponentClassId];
				this._dtBloodUnitMedia = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE BloodUnitGuid = '" + this._unitGuid.ToString() + "'", true);

				this._bpGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.RBC).BloodProductGuid;

				this.RefreshData = false;
			}

			_tstBUM = new BOL.BloodUnitMedia(this._unitGuid);
			_tstBUM.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.BloodUnitMedia);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.BloodUnitMedia tmpBUM = new BOL.BloodUnitMedia(this._unitGuid);

			Assert.AreEqual(this._unitGuid, tmpBUM.BloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._tstBUM.LoadDataRowFromThis(this._dtBloodUnitMedia.NewRow());

			Guid tstValue = (Guid)drTest[TABLES.BloodUnitMedia.BloodUnitMediaGuid];

			Assert.AreEqual(this._tstBUM.BloodUnitMediaGuid, tstValue);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void LoadDataRowFromThis_Fail()
		{
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(TABLES.BloodUnitMedia.BloodUnitMediaGuid, typeof(int));

			this._tstBUM.LoadDataRowFromThis(dtTest.NewRow());
		}


		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			bool retValue = this._tstBUM.Save(Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true,retValue, "Retun Value");
		}

		[Test]
		public void Save_Fail()
		{
			this._tstBUM.BloodUnitMediaGuid = Guid.Empty;
			bool retValue = this._tstBUM.Save(Common.UpdateFunction.UnitTests);

			Assert.AreEqual(false, retValue, "Return Value");
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Pass()
		{
			Guid patientGuid = (Guid)this._dtBloodUnitMedia.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid];

			DataTable dtTest = BOL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid);
			
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Fail()
		{
			DataTable dtTest = BOL.BloodUnitMedia.GetBloodUnitsByPatient(Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Int_Pass()
		{
			Guid patientGuid = (Guid)this._dtBloodUnitMedia.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid];

			DataTable dtTest = BOL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid, this._componentClassId);
			
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Int_Fail()
		{
			int classId = 0;
			Guid patientGuid = Guid.NewGuid();

			DataTable dtTest = BOL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid, classId);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void IsUnitAboRHConfirmationTested_Pass()
		{
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A' AND BloodTestTypeId IN (18,21)", false);
			if (dtTest.Rows.Count == 0)
			{
				BOL.BloodUnit newUnit = DataCreator.CreateRBCBloodUnit(true);
				DataCreator.CreateAboRhConfirmationTestsForUnit(newUnit.BloodUnitGuid, newUnit.BloodUnitMedia.AboRh);
				dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitTest WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A' AND BloodTestTypeId IN (18,21)", true);
			}
			Guid unitGuid = (Guid)dtTest.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid];

			BOL.BloodUnitMedia tmpBUM = new BOL.BloodUnitMedia(unitGuid);

			bool retValue = tmpBUM.IsUnitAboRHConfirmationTested(this.TestDivisionCode);

			Assert.AreEqual(true, retValue, "Return Value");
		}

		[Test]
		public void IsUnitAboRHConfirmationTested_Fail()
		{
			Guid unitGuid = Guid.NewGuid();
			DataCreator.CreateBloodUnit(unitGuid, Guid.NewGuid(), this._tstBUM.DirectedPatientGuid, this._bpGuid, true);

			BOL.BloodUnitMedia tmpBUM = new BOL.BloodUnitMedia(unitGuid);

			bool retValue = tmpBUM.IsUnitAboRHConfirmationTested(this.TestDivisionCode);
			
			Assert.AreEqual(false, retValue, "Return Value");
		}

		[Test]
		public void DoAboRHConfirmationsMatch_Pass()
		{
			BOL.BloodUnit newUnit = DataCreator.CreateRBCBloodUnit(true);

			DataCreator.CreateAboRhConfirmationTestsForUnit(newUnit.BloodUnitGuid, newUnit.BloodUnitMedia.AboRh);
			DataCreator.CreateAboRhConfirmationTestsForUnit(newUnit.BloodUnitGuid, newUnit.BloodUnitMedia.AboRh);

			BOL.BloodUnitMedia tmpBUM = new BOL.BloodUnitMedia(newUnit.BloodUnitGuid);

			bool retValue = tmpBUM.DoAboRHConfirmationsMatch(this.TestDivisionCode);

			Assert.AreEqual(true, retValue, "Return Value");
		}

		[Test]
		public void DoAboRHConfirmationsMatch_Fail()
		{
			Guid unitGuid = Guid.NewGuid();
			Guid busGuid = Guid.NewGuid();

			DataTable dataCheck = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 ConfirmationWorklistUnitGuid FROM BloodUnitTest WHERE DivisionCode = '" + this.TestDivisionCode + "' AND ConfirmationWorklistUnitGuid IS NOT NULL", false);
			if (dataCheck.Rows.Count == 0)
			{
				BOL.BloodUnit newUnit = DataCreator.CreateRBCBloodUnit(true);
				DataCreator.CreateAboRhConfirmationTestsForUnit(newUnit.BloodUnitGuid, newUnit.BloodUnitMedia.AboRh);
			}
			Guid cwGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ConfirmationWorklistUnitGuid FROM BloodUnitTest WHERE DivisionCode = '" + this.TestDivisionCode + "' AND ConfirmationWorklistUnitGuid IS NOT NULL");

			//CreateBloodUnit - create an A Pos unit
			DataCreator.CreateBloodUnit(unitGuid, busGuid, Guid.Empty, this._bpGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, true);

			BOL.BloodUnit tstUnit = new BOL.BloodUnit(unitGuid);

			//Since CreateBloodUnit() doesn't add any BloodUnitTests, the first IF condition should be hit -- no records found
			bool retValue = tstUnit.BloodUnitMedia.DoAboRHConfirmationsMatch(this.TestDivisionCode);
			Assert.AreEqual(false, retValue, "No ABO/Rh records found");

			//Create a BloodUnitTest for the ABO that doesn't match
			DataCreator.CreateBloodUnitTest(cwGuid, unitGuid, 18, "B");
			retValue = tstUnit.BloodUnitMedia.DoAboRHConfirmationsMatch(this.TestDivisionCode);
			Assert.AreEqual(false, retValue, "Abo mismatch");

			//Update the ABO record so that it does match
			UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET TestResultId = 'A' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'");

			//Create a BloodUnitTest record for the RH that doesn't match
			DataCreator.CreateBloodUnitTest(cwGuid, unitGuid, 21, "N");
			retValue = tstUnit.BloodUnitMedia.DoAboRHConfirmationsMatch(this.TestDivisionCode);
			Assert.AreEqual(false, retValue, "Rh mismatch");
		}


		[Test]
		public void BloodUnitMediaGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			this._tstBUM.BloodUnitMediaGuid = tstValue;

			Assert.AreEqual(this._tstBUM.BloodUnitMediaGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitMediaGuid_Fail()
		{
		}


		[Test]
		public void ABORh_Pass()
		{
			BOL.AboRh tstValue = this._tstBUM.AboRh;

			Assert.AreEqual(this._tstBUM.AboRh, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ABORh_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			this._tstBUM.BloodUnitGuid = tstValue;

			Assert.AreEqual(this._tstBUM.BloodUnitGuid, tstValue);		
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void BloodTypeCode_Pass()
		{
			string tstValue = "A";
			this._tstBUM.BloodTypeCode = tstValue;


			Assert.AreEqual(this._tstBUM.BloodTypeCode, tstValue, "BloodTypeCode");
			Assert.AreEqual(Common.ABO.A, this._tstBUM.AboRh.Abo, "Abo");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void BloodTypeCode_Fail()
		{
			//BloodTypeCode.Length can't be > 2
			string tstValue = "FAIL";
			this._tstBUM.BloodTypeCode = tstValue;
		}

		[Test]
		public void UnitExpirationDate_Pass()
		{
			DateTime tstValue = DateTime.Now.AddYears(1);
			this._tstBUM.UnitExpirationDate = tstValue;

			Assert.AreEqual(this._tstBUM.UnitExpirationDate, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitExpirationDate_Fail()
		{
		}
		[Test]
		public void SetUnitExpirationDate_Pass()
		{
			DateTime shipDate = DateTime.Now;
			DateTime expireDate = DateTime.Now.AddDays(1);

			int days = 5;
			int hours = 1;
			bool tstValue = false;

			this._tstBUM.SetUnitExpirationDate(shipDate, expireDate, days, hours, out tstValue);

			Assert.AreEqual(true, tstValue, "ReturnValue");
			Assert.AreEqual(expireDate, this._tstBUM.UnitExpirationDate, "UnitExpirationDate");
			Assert.AreEqual(false, this._tstBUM.IsRuleBroken(BROKEN.UnitExpirationDate), "BrokenRule.UnitExpirationDate");
		}

		[Test]
		public void SetUnitExpirationDateStorageDays1_Pass()
		{
			DateTime shipDate = DateTime.Now;
			DateTime expireDate = DateTime.Now.AddDays(1);

			int days = 1;
			int hours = 1;
			bool tstValue = false;

			this._tstBUM.SetUnitExpirationDate(shipDate, expireDate, days, hours, out tstValue);

			Assert.AreEqual(true, tstValue, "ReturnValue");
			Assert.AreEqual(expireDate, this._tstBUM.UnitExpirationDate, "UnitExpirationDate");
			Assert.AreEqual(false, this._tstBUM.IsRuleBroken(BROKEN.UnitExpirationDate), "BrokenRule.UnitExpirationDate");
		}

		[Test]
		public void SetUnitExpirationDate_Fail()
		{
			DateTime origDate = this._tstBUM.UnitExpirationDate;
			DateTime shipDate = DateTime.Now;
			DateTime expireDate = DateTime.Now.AddYears(99);

			int days = 5;
			int hours = 1;
			bool tstValue = true;

			this._tstBUM.SetUnitExpirationDate(shipDate, expireDate, days, hours, out tstValue);

			Assert.AreEqual(false, tstValue, "ReturnValue");
			Assert.AreEqual(origDate, this._tstBUM.UnitExpirationDate, "UnitExpirationDate");
			Assert.AreEqual(true, this._tstBUM.IsRuleBroken(BROKEN.UnitExpirationDate), "BrokenRule.UnitExpirationDate");
		}

		[Test]
		public void TestingStatusID_Pass()
		{
			int tstValue = this._tstBUM.TestingStatusId + 1;
			this._tstBUM.TestingStatusId = tstValue;

			Assert.AreEqual(this._tstBUM.TestingStatusId, tstValue);
		}

		[Test]
		public void TestingStatusID_Fail()
		{
			int tstValue = int.MinValue;
			this._tstBUM.TestingStatusId = tstValue;

			Assert.AreEqual(true, this._tstBUM.IsRuleBroken(BROKEN.TestingStatusId), "BrokenRule");
		}

		[Test]
		public void DirectedPatientGuid_Pass()
		{
			Guid tstValue = Guid.NewGuid();
			this._tstBUM.DirectedPatientGuid = tstValue;

			Assert.AreEqual(this._tstBUM.DirectedPatientGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DirectedPatientGuid_Fail()
		{
		}


		[Test]
		public void LastUpdateUser_Pass()
		{
			string tstValue = this._tstBUM.LastUpdateUser;

			Assert.AreEqual(this._tstBUM.LastUpdateUser, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateUser_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			byte[] tstValue = this._tstBUM.RowVersion;

			Assert.AreEqual(this._tstBUM.RowVersion.Length, tstValue.Length);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void CheckValidExpiredExpirationDate_Pass()
		{
			int currentBrokenRulesCount =  this._tstBUM.BrokenRulesCount;
			
			DateTime shipDate = DateTime.Now;
			DateTime expireDate = DateTime.Now.AddMinutes( 7 );
			
			this._tstBUM.Comments = "Oh yes, very nice";
			this._tstBUM.CheckValidExpiredExpirationDate( shipDate, expireDate );
			
			Assert.AreEqual(currentBrokenRulesCount - 1, this._tstBUM.BrokenRulesCount, "BrokenRuleCount" );
		}

		[Test]
		public void CheckValidExpiredExpirationDate_Fail()
		{
			int currentBrokenRulesCount =  this._tstBUM.BrokenRulesCount;
			
			DateTime shipDate = DateTime.Now;
			DateTime expireDate = DateTime.Now.AddMinutes( -7 );
			
			this._tstBUM.Comments = string.Empty;
			this._tstBUM.CheckValidExpiredExpirationDate( shipDate, expireDate );
			
			// Unit Expiration Date is broken initially, so we make sure it's still broken
			Assert.AreEqual(currentBrokenRulesCount, this._tstBUM.BrokenRulesCount,  "BrokenRuleCount" );
		}
		
		[Test]
		public void ReleaseRestriction_Pass()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NOT NULL");
			BOL.BloodUnit bu;
			bool bRetValue = false;
			if(dtData.Rows.Count >=0)
			{
				bu = new BOL.BloodUnit((System.Guid)dtData.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
				bRetValue = BOL.BloodUnitMedia.ReleaseRestriction(bu, "remove restriction", DateTime.Now, Common.LogonUser.LogonUserName, Common.UpdateFunction.UC011FrmProcessShipmentOut);
				Assert.AreEqual(true, bRetValue, "Return value successfull");
			}
			else
			{
				Assert.AreEqual(true, false, "No good data");
			}
		}
		[Test]
		public void ReleaseRestriction_Fail()
		{
		
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NULL");
			BOL.BloodUnit bu;
			bool bRetValue = false;

			
			bu = new BOL.BloodUnit((System.Guid)dtData.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
			bu.BloodUnitMedia.DirectedPatientGuid = System.Guid.Empty;
			bRetValue = BOL.BloodUnitMedia.ReleaseRestriction(bu, "U/T remove restriction", DateTime.Now, Common.LogonUser.LogonUserName, Common.UpdateFunction.UC011FrmProcessShipmentOut);
			Assert.AreEqual(false, bRetValue, "Return Value");
		}
		[Test]
		public void RestoreRestriction_Pass()
		{
			//first releast the restriction
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NOT NULL");
			
			BOL.BloodUnit bu;
			bool bRetValue = false;
			if(dtData.Rows.Count > 0)
			{
				bu = new BOL.BloodUnit((System.Guid)dtData.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
				bRetValue = BOL.BloodUnitMedia.ReleaseRestriction(bu, "remove restriction", DateTime.Now, Common.LogonUser.LogonUserName, Common.UpdateFunction.UC011FrmProcessShipmentOut);
				System.Data.DataTable dt = BOL.BloodUnitMedia.RestoreRestriction(bu, COMMON.UpdateFunction.UC013FrmInvalidateFinalStatus);
				if(dtData.Rows.Count == 0)
				{
					Assert.AreEqual(true, false, "No good data");
				}
				else
				{
					Assert.AreEqual(dt.Rows.Count, 1);
				}
			}
			else
			{
				Assert.AreEqual(true, false, "No good data");
			}
			
		}
		[Test]
		public void RestoreRestriction_Fail()
		{
			//Get a unit wiht no former restriction
			BOL.BloodUnit bu = DataCreator.CreateBloodUnit(true);
			//attempt to restore a non existant restriction
			System.Data.DataTable dt = BOL.BloodUnitMedia.RestoreRestriction(bu, COMMON.UpdateFunction.UnitTests);
			Assert.AreEqual(true, dt.Rows.Count ==0, "No patient");
		}
	}
}
#endif
